/** @file   proctoralien.h
 * @brief   Declaration of ProctorAlien class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:42 $
 * @author  Tomi Lamminsaari
 */
 
#ifndef H_WWW_PROCTORALIEN_H
#define H_WWW_PROCTORALIEN_H

#include "alien.h"


namespace WeWantWar {


/** @class  ProctorAlien
 * @brief   Represents the alien with shotgun.
 * @author  Tomi Lamminsaari
 */
class ProctorAlien : public Alien
{
public:

  ///
  /// Static members
  /// ==============
  
  /** Index of the controlpoint where we've stored the coordinates of the
   * shotgun pipe.
   */
  static const int GUN_CONTROLPOINT_INDEX;
  
  
  ///
  /// Constructors, destructor
  /// ========================
  
  /** Constructor.
   */
  ProctorAlien();
  
  /** Destructor.
   */
  virtual ~ProctorAlien();
  
  
  
  ///
  /// Methods
  /// =======
  
  /** Updates this alien.
   */
  virtual void update();
  
  /** Kills this alien.
   */
  virtual void kill();
  
  /** Makes sound.
   * @param     id                ID of the sound.
   */
  virtual void makeSound( GameObject::SoundID id ) const;
  
  /** We implement this so that we can inform the ai-object when
   * we got shot.
   * @param     pB                Pointer to Bullet that hit us.
   * @return    <code>true</code> if we died
   */
  virtual bool causeDamage( Bullet* pB );
  
  /** This alien got hit by given bullet. The bullets can go through the
   * Alien if it was shot by another alien.
   * @param     pB                Pointer to bullet that hit us.
   * @return    'true' if this bullet did hit us. 'false' means it went
   *            through.
   */
  virtual bool hitByBullet( Bullet* pB );
  
  
  ///
  /// Getter methods
  /// ==============
  
  /** Returns the type of this object.
   * @return    GameObject::TYPE_PROCTORALIEN
   */
  virtual ObjectID::Type objectType() const;
  

  
protected:

  /** Sets the requested animation.
   * @param     aAnimId           ID of the animation.
   */
  virtual void setCorrectAnimation( int aAnimId );
  
  /** Shoots.
   */
  virtual void attack();
  
  
  
  ///
  /// Members
  /// =======
  
  /** The speedvector */
  eng2d::Vec2D  m_speedVec;
  
private:
  ProctorAlien( const ProctorAlien& rO );
  ProctorAlien& operator = ( const ProctorAlien& rO );
};

};  // end of namespace


#endif // PROCTORALIEN_H

/**
 * Version history
 * ===============
 * $Log: proctoralien.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:11+02  lamminsa
 * Initial revision
 *
 */
 
